function [Kt, Kq, eta0] = propcalc(Z, AeA0, PD, J, Rn)
%PROPCALC Calculates the Wageningen B-Series polynomials from the
%polynomial fits from Carlton J. - Marine Propellers and Propulsion created
%by ir. EAE Duchateau (version 08-04-2013)
%
%
% Input Parameters:
%   Z       = Number of blades (2 - 7)
%   AeA0    = Blade area ratio (0.30 - 1.05)
%   PD      = Pitch/diamter ratio (0.6 - 1.4)
%   J       = Advance (J = Va/(n*D))
%   (Rn)    = Reynolds number (2e6 - 2e9)

if nargin <5
    Rn = [];
end

% Z=4
% AeA0=0.85
% PD=1.2
% J=[0:0.2:1.2]
% Rn=[]

J = reshape(J,[],1);

% Coefficients
CKt = [ 0.00880496 0 0 0 0;
        -0.204554 1 0 0 0;
        0.166351 0 1 0 0;
        0.158114 0 2 0 0;
        -0.147581 2 0 1 0;
        -0.481497 1 1 1 0;
        0.415437 0 2 1 0;
        0.0144043 0 0 0 1;
        -0.0530054 2 0 0 1;
        0.0143481 0 1 0 1;
        0.0606826 1 1 0 1;
        -0.0125894 0 0 1 1;
        0.0109689 1 0 1 1;
        -0.133698 0 3 0 0;
        0.00638407 0 6 0 0;
        -0.00132718 2 6 0 0;
        0.16849 3 0 1 0;
        -0.0507214 0 0 2 0;
        0.0854559 2 0 2 0;
        -0.0504475 3 0 2 0;
        0.010465 1 6 2 0;
        -0.00648272 2 6 2 0;
        -0.00841728 0 3 0 1;
        0.0168424 1 3 0 1;
        -0.00102296 3 3 0 1;
        -0.0317791 0 3 1 1;
        0.018604 1 0 2 1;
        -0.00410798 0 2 2 1;
        -0.000606848 0 0 0 2;
        -0.0049819 1 0 0 2;
        0.0025983 2 0 0 2;
        -0.000560528 3 0 0 2;
        -0.00163652 1 2 0 2;
        -0.000328787 1 6 0 2;
        0.000116502 2 6 0 2;
        0.000690904 0 0 1 2;
        0.00421749 0 3 1 2;
        0.0000565229 3 6 1 2;
        -0.00146564 0 3 2 2];

CKq = [ 0.00379368 0 0 0 0;
        0.00886523 2 0 0 0;
        -0.032241 1 1 0 0;
        0.00344778 0 2 0 0;
        -0.0408811 0 1 1 0;
        -0.108009 1 1 1 0;
        -0.0885381 2 1 1 0;
        0.188561 0 2 1 0;
        -0.00370871 1 0 0 1;
        0.00513696 0 1 0 1;
        0.0209449 1 1 0 1;
        0.00474319 2 1 0 1;
        -0.00723408 2 0 1 1;
        0.00438388 1 1 1 1;
        -0.0269403 0 2 1 1;
        0.0558082 3 0 1 0;
        0.0161886 0 3 1 0;
        0.00318086 1 3 1 0;
        0.015896 0 0 2 0;
        0.0471729 1 0 2 0;
        0.0196283 3 0 2 0;
        -0.0502782 0 1 2 0;
        -0.030055 3 1 2 0;
        0.0417122 2 2 2 0;
        -0.0397722 0 3 2 0;
        -0.00350024 0 6 2 0;
        -0.0106854 3 0 0 1;
        0.00110903 3 3 0 1;
        -0.000313912 0 6 0 1;
        0.0035985 3 0 1 1;
        -0.00142121 0 6 1 1;
        -0.00383637 1 0 2 1;
        0.0126803 0 2 2 1;
        -0.00318278 2 3 2 1;
        0.00334268 0 6 2 1;
        -0.00183491 1 1 0 2;
        0.000112451 3 2 0 2;
        -0.0000297228 3 6 0 2;
        0.000269551 1 0 1 2;
        0.00083265 2 0 1 2;
        0.00155334 0 2 1 2;
        0.000302683 0 6 1 2;
        -0.0001843 0 0 2 2;
        -0.000425399 0 3 2 2;
        0.0000869243 3 3 2 2;
        -0.0004659 0 6 2 2;
        0.0000554194 1 6 2 2];
    
    
    
    
    
    

% Kt calculation 
temp = zeros(39,length(J));

for i = 1:39
    temp(i,:) = CKt(i,1).*J.^CKt(i,2).*PD.^CKt(i,3).*AeA0.^CKt(i,4).*Z.^CKt(i,5);
end

Kt = sum(temp);
Kt = Kt';

if ~isempty(Rn)
    dKt = 0.000353485 ...
        - 0.00333758.*AeA0.*J.^2 ...
        - 0.00478125.*AeA0.*PD.*J ...
        + 0.000257792*(log10(Rn)-0.301)^2*AeA0.*J.^2 ...
        + 0.0000643192*(log10(Rn)-0.301)*PD^6.*J.^2 ...
        - 0.0000110636*(log10(Rn)-0.301)^2*PD^6.*J.^2 ...
        - 0.0000276305*(log10(Rn)-0.301)^2*Z*AeA0.*J.^2 ...
        + 0.0000954*(log10(Rn)-0.301)*Z*AeA0*PD.*J ...
        + 0.0000032049*(log10(Rn)-0.301)*Z^2*AeA0*PD^3.*J;
    Kt = Kt + dKt;
end







% Kq calculation
temp = zeros(47,length(J));

for i = 1:47
    temp(i,:) = CKq(i,1).*J.^CKq(i,2).*PD.^CKq(i,3).*AeA0.^CKq(i,4).*Z.^CKq(i,5);
end

Kq = sum(temp);
Kq = Kq';

if ~isempty(Rn)
    dKq = - 0.000591412 ...
        + 0.00696898*PD ...
        - 0.0000666654*Z*PD^6 ...
        + 0.0160818*AeA0^2 ...
        - 0.000938091*(log10(Rn)-0.301)*PD ...
        - 0.00059593*(log10(Rn)-0.301)*PD^2 ...
        + 0.0000782099*(log10(Rn)-0.301)^2*PD^2 ...
        + 0.0000052199*(log10(Rn)-0.301)*Z*AeA0.*J.^2 ...
        - 0.00000088528*(log10(Rn)-0.301)^2*Z*AeA0*PD.*J ...
        + 0.0000230171*(log10(Rn)-0.301)*Z*PD^6 ...
        - 0.0000018434*(log10(Rn)-0.301)^2*Z*PD^6 ...
        - 0.00400252*(log10(Rn)-0.301)*AeA0^2 ...
        + 0.000220915*(log10(Rn)-0.301)^2*AeA0^2;
    Kq = Kq + dKq;
end



% Etha 0
eta0 = (Kt./Kq).*(J./(2*pi));
eta0((find(eta0<0,1)+1):end) = NaN;


%% OUTPUT
% plot(J,Kt,J,10.*Kq,J,eta0)
% title(['Wageningen B' num2str(Z) '.' num2str(100*AeA0) '  P/D = ' num2str(PD)])
% grid on
% axis([0 J(end) 0 1])
% legend('K_T','10*K_Q','\eta_0')
% J
% Kt
% Kq
% eta0

end
